#include <iostream>
#include <vector>
#include <set>

#define rep(a, b)   for(int a = 0; a < (b); ++a)
#define all(a)      begin(a),end(a)

using namespace std;
using ll = long long;

struct Mex {
    int mex = 0;
    set<int> s;
    void add(int i) {
        s.insert(i);
        while(s.contains(mex)) mex++;
    }
    void merge(Mex& other) {
        mex = max(mex, other.mex);
        // if(size(s) < size(other.s)) swap(s, other.s); // smaller into larger
        for(int e : other.s) add(e);
    }
};

int main() {
    ios::sync_with_stdio(false);

    int n; cin>>n;
    vector<vector<int>> adj(n);
    rep(i,n-1) {
        int u,v; cin>>u>>v;
        --u; --v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    vector ans(n,0);
    auto dfs = [&](auto& self, int u, int p=-1) -> Mex {
        Mex mine; mine.add(u);
        int min_in_subtree = n;
        bool first = true;
        for(int v : adj[u]) {
            if(v==p) continue;
            auto sub = self(self, v, u);
            min_in_subtree = min(min_in_subtree, *begin(sub.s));
            sub.add(u);
            ans[u] = max(ans[u], sub.mex);
            if(first) swap(sub, mine), first = false;
            mine.merge(sub);
        }
        ans[u] = max(ans[u], min_in_subtree);
        return mine;
    };
    dfs(dfs, 0);

    rep(i,n) cout << ans[i] << " \n"[i==n-1];

    return 0;
}
