#include <iostream>
#include <vector>
#include <set>

#define rep(a, b)   for(int a = 0; a < (b); ++a)
#define all(a)      begin(a),end(a)

using namespace std;
using ll = long long;

struct Mex {
    set<int> s;
    int mex(){
        int x = 0;
        while(s.contains(x)) x++;
        return x;
    }
    void merge(Mex& other) {
        if(size(s) < size(other.s)) swap(s, other.s); // smaller into larger
        for(int e : other.s) s.insert(e);
    }
};

int main() {
    ios::sync_with_stdio(false);

    int n; cin>>n;
    vector<vector<int>> adj(n);
    rep(i,n-1) {
        int u,v; cin>>u>>v;
        --u; --v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    vector ans(n,0);
    auto dfs = [&](auto& self, int u, int p=-1) -> Mex {
        Mex mine; mine.s.insert(u);
        int min_in_subtree = n;
        for(int v : adj[u]) {
            if(v==p) continue;
            auto sub = self(self, v, u);
            min_in_subtree = min(min_in_subtree, *begin(sub.s));
            sub.s.insert(u);
            ans[u] = max(ans[u], sub.mex());
            mine.merge(sub);
        }
        ans[u] = max(ans[u], min_in_subtree);
        return mine;
    };
    dfs(dfs, n-1);

    rep(i,n) cout << ans[i] << " \n"[i==n-1];

    return 0;
}
