#include <algorithm>
#include <iostream>
#include <vector>

#define rep(a, b)   for(int a = 0; a < (b); ++a)
#define all(a)      begin(a),end(a)

using namespace std;

int main() {
    ios::sync_with_stdio(false);

    int n; cin>>n;
    vector<vector<int>> adj(n);
    rep(i,n-1) {
        int u,v; cin>>u>>v;
        --u; --v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    vector<int> depth(n), parent(n);
    auto dfs = [&](auto&& self, int u, int p=-1, int d=0) -> void {
        depth[u] = d;
        parent[u] = p;
        for(int v : adj[u])
            if(v!=p) self(self, v, u, d+1);
    };
    dfs(dfs, 0);

    vector ans(n,n);
    auto walk = [&](int u, int v) {
        int orig_u = u, orig_v = v;
        while(u!=v) {
            if(depth[u]<depth[v]) swap(u,v);
            u = parent[u];
            if(u!=orig_u && u!=orig_v) ans[u] = min(ans[u], orig_v);
        }
    };

    rep(i,n-1) walk(i, i+1);
    rep(i,n-2) walk(i, i+2);
    rep(i,n) cout << ans[i] << " \n"[i==n-1];

    return 0;
}
