#include <algorithm>
#include <iostream>
#include <vector>

#define rep(a, b)   for(int a = 0; a < (b); ++a)
#define all(a)      begin(a),end(a)

using namespace std;

int mex(vector<int>& a) {
    sort(all(a));
    a.erase(unique(all(a)), end(a));
    rep(i,size(a)) if(a[i]!=i) return i;
    return size(a);
}

int main() {
    ios::sync_with_stdio(false);

    int n; cin>>n;
    vector<vector<int>> adj(n);
    rep(i,n-1) {
        int u,v; cin>>u>>v;
        --u; --v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    auto collect_reachable = [&](auto&& self, int u, int p, vector<int>& reach) -> void {
        reach.push_back(u);
        for(int v : adj[u])
            if(v!=p) self(self, v, u, reach);
    };

    vector<int> ans(n);
    auto dfs = [&](auto&& self, int u, int p=-1) -> void {
        for(int v : adj[u]) {
            vector reach{u};
            collect_reachable(collect_reachable, v, u, reach);
            ans[u] = max(ans[u], mex(reach));
        }

        for(int v : adj[u])
            if(v!=p) self(self, v, u);
    };
    dfs(dfs, 0);

    rep(i,n) cout << ans[i] << ' ';

    return 0;
}
