#include <bits/stdc++.h>
using namespace std;
using ll = int64_t;
#define all(x) ::begin(x), ::end(x)
void _d(auto... x) { ((cerr << ' ' << x), ...) << endl; }
#define debug(x...) cerr << "["#x"]:", _d(x)

struct Thing {
    set<int> s;
    int mex = 0;

    void insert(int i) {
        s.insert(i);
        while (s.count(mex)) mex++;
    }
};

void merge(Thing& a, Thing& b) {
    if (ssize(a.s) < ssize(b.s)) swap(a, b);
    for (int e : b.s) a.insert(e);
    b = {};
}

int main() {
    cin.tie(0)->sync_with_stdio(0);

    int n;
    cin >> n;
    vector<vector<int>> g(n);
    for (int i=1; i<n; i++) {
        int u, v;
        cin >> u >> v;
        u--, v--;
        g[u].push_back(v);
        g[v].push_back(u);
    }

    vector<Thing> dp(n);
    vector<int> ans(n);
    auto dfs = [&](auto& self, int u, int p) -> void {
        for (int v : g[u]) if (v != p) {
            self(self, v, u);
            dp[v].insert(u);
            ans[u] = max(ans[u], dp[v].mex);
            merge(dp[u], dp[v]);
        }
        dp[u].s.erase(u);
        if (g[u].size() == 1) ans[u] = n;
        else assert(!dp[u].s.empty()), ans[u] = max(ans[u], *dp[u].s.begin());
        dp[u].s.insert(u);
    };
    dfs(dfs, 0, 0);
    
    for (int e : ans) cout << e << ' ';
    cout << '\n';
}
