#include<bits/stdc++.h>
using namespace std;

const int MAXN = 300000;
int n;
vector<int> adj[MAXN];

typedef long long ll;
const int ooo = 0x3f3f3f3f;

vector<int> values;
pair<int, int> bounds[MAXN];
int parent[MAXN];

struct Tree {
        typedef ll T;
        static constexpr T unit = ooo;
        T f(const T& a, const T& b) { return min(a, b); } // any assoc fn
        vector<T> s; ll n;
        Tree(ll n = 0, T init = unit) : s(2*n, init), n(n) {}
        void update(ll i, const T& val) {
                for(s[i += n] = val; i /= 2;)
                        s[i] = f(s[i*2], s[i*2+1]);
        }
        T query(ll b, ll e) { // query [b, e)
                T ra = unit, rb = unit;
                for(b += n, e += n; b < e; b /= 2, e /= 2) {
                        if(b % 2 != 0) ra = f(ra, s[b++]);
                        if(e % 2 != 0) rb = f(s[--e], rb);
                }
                return f(ra, rb);
        }
};

bool dfs(int u, int p){
    parent[u] = p;
    int start = values.size();
    values.push_back(u);

    bool has_one = u == 1;

    for(int v: adj[u]){
        if(v == p) continue;
        bool res = dfs(v, u);
        if(u == 0 && res) parent[u] = v;
        has_one |= res;
    }
    int end = values.size()-1;
    bounds[u] = {start, end};
    return has_one;
}

int get_min_in_subtree(int u, Tree * t){
    return t->query(bounds[u].first, bounds[u].second+1);
}

int get_min_out_subtree(int u, Tree * t){
    return min(t->query(0, bounds[u].first), t->query(bounds[u].second+1, values.size()));
}

int main(){
    cin >> n;

    for(int i=0; i<n-1; i++){
        int a, b;
        cin >> a >> b;
        adj[a-1].push_back(b-1);
        adj[b-1].push_back(a-1);
    }
    
    parent[0] = -1;
    memset(parent, 0, sizeof(parent));
    dfs(0, -1);

    Tree * t = new Tree(values.size(), 0x3f3f3f3f);
    for(int i=0; i<values.size(); i++) t->update(i, values[i]);

    for(int u=0; u<n; u++){
        int best = n;
        for(int v: adj[u]) if(v != parent[u]) best = min(best, get_min_in_subtree(v, t));  
        cout << best << " ";     
    }
    cout << endl;
}