{-# LANGUAGE Strict #-}
import qualified Data.ByteString.Char8 as B
import Data.Graph
import Data.Array.Unboxed
import Control.Monad
import Control.Monad.State
import Data.Foldable
int x = case B.readInt x of Just (i,_) -> i
main = B.getContents >>= putStrLn . unwords . map show . solve . map (map int . B.words) . B.lines

treefoldM f (Node a b) = mapM (treefoldM f) b >>= f a

solve :: [[Int]] -> [Int]
solve ([n]:es) = pred <$> elems res
 where
  g = buildG (1,n) $ concat [ [(u,v),(v,u)] | [u,v] <- es]
  t = head $ dfs g [1]
  vislo, vishi, res :: UArray Int Int
  vislo = array (1,n) (zip (toList t) [0..])
  vishi = array (1,n) $ flip execState [] $ flip treefoldM t $ \i ch -> let t = foldl' max (vislo!i) ch in t <$ modify' ((i,t):)
  findMex j i m = head $ [ t | t <- [m..], t /= i, t > n || vislo!t < vislo!j || vishi!t > vishi!j]
  res = accumArray max 0 (1,n) $ flip execState [] $ flip treefoldM t $ \i ch -> do
   let mex = foldl' max 1 [ findMex j i m | (j,m,_) <- ch ]
       m = foldl' min (n + 1) [ m | (_,_,m) <- ch ]
   modify' ((i, max mex m):)
   return (i, findMex i i mex, min i m)
