#include <iostream>
#include <vector>

#define rep(a, b)   for(int a = 0; a < (b); ++a)
#define all(a)      begin(a),end(a)

using namespace std;
using ll = long long;
constexpr int INF = 1e9;

struct Segtree {
    int n = 1;
    vector<int> seg;
    Segtree(int _n)  {
        while(n < _n) n *= 2;
        seg.resize(2*n);
    }
    void update(int i, int val) {
        seg[i+=n] = val;
        while(i/=2) seg[i] = min(seg[2*i],seg[2*i+1]);
    }
    int query(int l, int r) {
        int res = INF;
        for(l+=n, r+=n; l<r; l/=2, r/=2) {
            if(l&1) res = min(res, seg[l++]);
            if(r&1) res = min(res, seg[--r]);
        }
        return res;
    }
};

int main() {
    ios::sync_with_stdio(false);

    int n; cin>>n;
    vector<vector<int>> adj(n);
    rep(i,n-1) {
        int u,v; cin>>u>>v;
        --u; --v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    vector<int> euler, first(n), last(n);
    auto dfs = [&](auto& self, int u, int p=-1) -> void {
        first[u] = size(euler);
        euler.push_back(u);
        for(int v : adj[u])
            if(v!=p) self(self, v, u);
        last[u] = size(euler);
    };
    dfs(dfs, 0);

    Segtree seg(n);
    rep(u,n) seg.update(u, euler[u]);
    rep(u,n) {
        seg.update(first[u], n);
        int ans = seg.query(first[u], last[u]);
        for(int v : adj[u]) {
            if(first[v]<first[u]) continue; // parent
            int min_excluded = min(seg.query(0, first[v]), seg.query(last[v], n));
            ans = max(ans, min_excluded);
        }
        cout << ans << " \n"[u==n-1];
        seg.update(first[u], u);
    }

    return 0;
}
