#include "validation.h"

struct DSU {
    std::vector<int> parent;
    DSU(int n) : parent(n) { iota(begin(parent),end(parent),0); }
    void join(int u, int v) { parent[find(u)] = find(v); }
    int find(int v) {
        if(parent[v] == v) return v;
        return parent[v] = find(parent[v]);
    }
};

int main(int argc, char *argv[]) {
    InputValidator v(argc, argv);
    int n = v.read_integer("n", 2, 200'000);
    v.newline();

    DSU dsu(n);
    for(int i=0; i<n-1; ++i) {
        int a = v.read_integer("u", 1, n);
        v.space();
        int b = v.read_integer("v", 1, n);
        v.check(a!=b, "self-loop");
        dsu.join(a-1, b-1);
        v.newline();
    }

    bool connected = true;
    for(int i=0; i<n-1; ++i) 
        connected &= (dsu.find(i) == dsu.find(i+1));
    v.check(connected, "not connected");
}
